<?php include "template/header.php"?>

<section class="page_slider overflow-visible">
    <div class="flexslider">
        <ul class="slides">
            <li class="cs cover-image text-center text-md-left">
                <img src="template/images/slide01.jpg" alt="img">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <div class="intro_layers_wrapper">
                                <div class="img-layer animate" data-animation="fadeInLeft">
                                    <img src="template/img/book-cover-img.png" alt="img">
                                </div>
                                <div class="intro_layers">
                                    <div class="intro_layer" data-animation="fadeInRight">
                                        <h3>Outstanding Work from the Best in the Business!</h3>
                                    </div>
                                    <div class="intro_layer" data-animation="fadeInRight">
                                        <p>You have the vision to dream and conceptualize. We have the power of words to put them out for the world to read.</p>
                                    </div>
                                    <div class="intro_layer several-buttons" data-animation="fadeInUp">
                                        <a href="#" class="btn btn-maincolor">LET'S GET STARTED</a>
                                    </div>
                                </div> <!-- eof .intro_layers -->
                            </div> <!-- eof .intro_layers_wrapper -->
                        </div> <!-- eof .col-* -->
                    </div><!-- eof .row -->
                </div><!-- eof .container-fluid -->
            </li>
        </ul>
    </div> <!-- eof flexslider -->
</section>


<section id="author" class="ls s-overlay mobile-overlay s-py-90 s-py-xl-150 section-about">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="divider-xl-200"></div>
                <h2 class="special-heading">
                    <span>THE BEST IN THE INDUSTRY</span>
                </h2>
                <div class="divider-40"></div>
                <p class="excerpt">Native Publishing House…is Changing the Game</p>
                <div class="divider-40"></div>
                <p>
                    Have you ever aspired to putting pen to paper and becoming a writer? Is there a novel, a tale, or even a short story knocking about in your head that is just aching to be set free? Well, you’re finally in luck! Here at Native Publishing House, we offer just the right mix of services to help your literary fantasy get published and reach the world.
                </p>
                <p>
                The hurdles to bringing one’s idea to life and getting published, followed by printing, distributing, and marketing your thoughts realized in written form, are understandable. Be it a rejected manuscript, writer’s block, perfectionism, or the simple conclusion that the writing and proofreading process is not your cup of tea. Native Publishing House is here to put your mind at ease with our premium self-publishing services designed to take the burden off your shoulders. Read on or contact us to learn more!
                </p>
                <ul class="list-styled">
                    <div class="row">
                        <div class="col-md-6">
                            <li>
                                <i class="fas fa-check"></i> Book Marketing
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Book Publishing
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Book Editing
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Book Writing
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Proofreading and Editing
                            </li>
                        </div>
                        <div class="col-md-6">
                            <li>
                                <i class="fas fa-check"></i> Content Formatting
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Book Cover Designing
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Audio Books
                            </li>
                            <li>
                                <i class="fas fa-check"></i> Video Trailers
                            </li>
                        </div>
                    </div>
                </ul>
                <div class="divider-40"></div>
                <div class="divider-xl-150"></div>
            </div>
        </div>
    </div>
</section>

<section id="about" class="ls ms s-py-90 s-py-xl-160 c-gutter-100">
    <h2 class="special-heading text-center pt-5 mt-5">
        <span>Our Services</span>
    </h2>
    <p class="mb-2 color-dark text-center pt-2">FULFILLING ALL YOUR WRITING NEEDS</p>
    <div class="container">
        <div class="row align-center">
            <div class="col-lg-6">
                <div class="video-shortcode">
                    <img src="template/images/services/service-1.jpg" alt="img">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="divider-60 divider-lg-0"></div>
                <h3 class="special-heading">
                    <span>BOOK WRITING</span>
                </h3><br>
                <h6 class="special-heading">
                    <span>Amaze Everyone with Our Top-Notch Premium Writing Services</span>
                </h6>
                <div class="divider-40"></div>
                <p>
                    Native Publishing House’s seasoned team of writers are well versed and fully capable of staying true to the subject matter of your book. They know precisely what industry 		standards and best practices to follow to ensure the delivery of high-quality content in the course of their book-writing duties. <br>
We aim to provide our partners with what they want and, more often than not, do our level best to exceed expectations.

                </p>
                <div class="divider-40">
                    <a href="ghostwriting.php" class="btn btn-darkgrey">Read More</a>
                </div>
            </div>
        </div>
        <div class="row align-center">
            <div class="col-12">
                <div class="divider-80 divider-xl-120"></div>
            </div>
            <div class="col-lg-6 order-2 order-lg-1">
                <div class="divider-60 divider-lg-0"></div>
                <h3 class="special-heading">
                    <span>BOOK PUBLISHING</span>
                </h3>
                <br>
                <h6 class="special-heading">
                    <span>Get Started with Experienced Publishers Who Know What They Are Doing</span>
                </h6>
                <div class="divider-40"></div>
                <p>Native Publishing House’s Book Publishing team has some of the most extensive book publication experience in the industry on the most established platforms in book publishing. We have established a name for ourselves, publishing on Amazon, Barnes and Noble, Ingram Spark, Apple Books, Google Books, and a whole host of other publication platforms. We have honed our publication process to an art form and achieve our goals in the most efficient and effective way possible. We offer all requisite services: book publishing, printing, onward distribution, and marketing. <br>
Turn to Native Publishing House for all your Book Publishing Needs! 
</p>
                <div class="divider-40">
                    <a href="book-publishing.php" class="btn btn-darkgrey">Read More</a>
                </div>
            </div>
            <div class="col-lg-6 order-1 order-lg-2">
                <div class="border-r-def overflow-hidden">
                    <img src="template/images/services/service-2.jpeg" alt="img">
                </div>
            </div>
        </div>
        <div class="row align-center">
            <div class="col-12">
                <div class="divider-80 divider-xl-120"></div>
            </div>
            <div class="col-lg-6">
                <div class="border-r-def overflow-hidden">
                    <img src="template/images/gallery-square/20.jpg" alt="img">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="divider-60 divider-lg-0"></div>
                <h3 class="special-heading">
                    <span>BOOK MARKETING</span>
                </h3>
                <br>
                <h6 class="special-heading">
                    <span>Use the Right Marketing and Promotion Tools for all your Book Marketing Activities</span>
                </h6>
                <div class="divider-40"></div>
                <p>
                    In the era of self-publishing platforms for both books and media, all one needs is guidance, advice, and a slight nudge in the right direction. Native Publishing House is here to help you with all of the above and then some. To learn more about our book marketing approach, contact us today, and let’s see how we can partner and help each other out and give your book the sales boost it needs!</p>
                <div class="divider-40">
                    <a href="book-marketing.php" class="btn btn-darkgrey">Read More</a>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="ls s-py90 s-pt-xl-155 s-pb-xl-160">
    <div class="container">
    <div class="owl-slider">
<div id="carousel" class="owl-carousel">
	<div class="item">
		<img src="template/img/books/ghost-writing-1.jpg" alt="1000X1000">
	</div>
	<div class="item">
		<img src="template/img/books/ghost-writing-2.jpg" alt="">
	</div>
	<div class="item">
		<img src="template/img/books/ghost-writing-3.jpg" alt="">
	</div>
	<div class="item">
		<img src="template/img/books/ghost-writing-4.jpg" alt="">
	</div>
  	<div class="item">
		<img src="template/img/books/creative-writing-1.jpg" alt="">
	</div>
	<div class="item">
		<img src="template/img/books/creative-writing-2.jpg" alt="">
	</div>
	<div class="item">
		<img src="template/img/books/creative-writing-3.jpg" alt="">
	</div>
</div>
</div>
    </div>
</section>

<section id="quotes" class="ds section-testimonials s-py-90 s-py-xl-150">
    <h2 class="special-heading text-center pt-5 mt-5">
        <span>REVIEWS</span>
    </h2>
    <p class="mb-2 color-dark text-center pt-2">FEEDBACK FROM OUR CLIENTS.</p>
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="owl-carousel owl-nav-bottom" data-responsive-lg="3" data-responsive-md="2" data-responsive-sm="1" data-responsive-xs="1" data-nav="true" data-margin="60" data-loop="true" data-autoplay="true">
                    <div class="vertical-item quote-item">
                        <div class="item-content text-center">
                            <img src="template/images/test-icon.png" alt="">
                            <h4 class="mb-3">
                                Julia Jameson
                            </h4>
                            <p><span>“</span>I was referred to Native Publishing House by a family friend of mine and I can’t thank him enough for this recommendation. Their qualified professionals took enough time to understand the concept of my book and paid attention to detail in order to publish it on my selected platforms.<span>”</span></p>
                        </div>
                    </div>
                    <div class="vertical-item quote-item">
                        <div class="item-content text-center">
                            <img src="template/images/test-icon.png" alt="">
                            <h4 class="mb-3">
                                Samantha Biggs
                            </h4>
                            <p><span>“</span>It was a pleasure working with Native Publishing House because for the very first time I did not have to run after the writer to get changes done. Their team was very cooperative and whenever I asked for an update they would give me an accurate update. From the writing style to the book cover, everything was on point and I would love to work with them in the future.<span>”</span></p>
                        </div>
                    </div>
                    <div class="vertical-item quote-item">
                        <div class="item-content text-center">
                            <img src="template/images/test-icon.png" alt="">
                            <h4 class="mb-3">
                                Roy Myers
                            </h4>
                            <p><span>“</span>I have been working with them to create posts for my blog for about 3 weeks and the response has been amazing. People love my posts and I have been called to address students at different colleges about their career choices and professional life. Their writers are very professional and they know what they are writing.<span>”</span></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<section id="mail" class="ls ms s-py-90 s-py-xl-160">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <div class="divider-lg-60"></div>
                <h2 class="special-heading">
                    <span>Get in touch</span>
                </h2>
                <div class="divider-35"></div>
                <ul class="pl-0">
                    <li class="icon-inline">
                        <div class="icon-styled color-main fs-16">
                            <i class="fa fa-phone"></i>
                        </div>
                        <p>+1(215) 449 8101 | +1(628) 256 4002</p>
                    </li>
                    <li class="icon-inline links-grey">
                        <div class="icon-styled color-main fs-16">
                            <i class="fa fa-paper-plane-o"></i>
                        </div>
                        <p>
                            <a href="mailto:info@nativepublishinghouse.com">info@nativepublishinghouse.com</span></a>
                        </p>
                    </li>
                    <li class="icon-inline">
                        <div class="icon-styled color-main fs-16">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <p>100 Pine St Suite 1150-1151 , San Francisco,<br> CA 94111</p>
                    </li>
                </ul>
                <div class="divider-35"></div>
                <p class="social-icons">
                    <a href="https://www.facebook.com/" class="fa border-icon rounded-icon fa-facebook" title="facebook"></a>
                    <a href="https://twitter.com/" class="fa border-icon rounded-icon fa-twitter" title="twitter"></a>
                    <a href="https://www.linkedin.com/" class="fa border-icon rounded-icon fa-linkedin" title="linkedin"></a>
                    <a href="https://www.youtube.com/" class="fa border-icon rounded-icon fa-youtube-play" title="linkedin"></a>
                    <a href="https://www.instagram.com/" class="fa border-icon rounded-icon fa-instagram" title="linkedin"></a>
                </p>
            </div>
            <div class="col-lg-8">
                <div class="divider-lg-0 divider-60"></div>
                <div class="inner-wrap ls p-30 p-xl-70 border-r-def">
                    <form class="c-mb-50 c-gutter-50" method="post">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group has-placeholder">
                                    <label for="name">Full Name <span class="required">*</span></label>
                                    <input type="text" aria-required="true" size="30" value="" name="name" id="name" class="form-control" placeholder="Name">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group has-placeholder">
                                    <label for="email">Email address<span class="required">*</span></label>
                                    <input type="email" aria-required="true" size="30" value="" name="email" id="email" class="form-control" placeholder="Email">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group has-placeholder">
                                    <label for="subject">Subject<span class="required">*</span></label>
                                    <input type="phone" aria-required="true" size="30" value="" name="phone" id="phone" class="form-control" placeholder="Phone">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group has-placeholder">
                                    <label for="message">Your message</label>
                                    <textarea aria-required="true" rows="3" cols="45" name="message" id="message" class="form-control" placeholder="Message"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="wrap-forms">
                            <div class="row">
                                <div class="col-12">
                                    <button type="submit" name="reserve-discount" class="btn btn-maincolor">Send a message</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--.col-* -->
        </div>
    </div>
</section>

<?php include "template/footer.php"?>